package com.biz.crm.nebular.activiti.act.req;

import com.biz.crm.nebular.mdm.PageVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 请求vo
 *
 * @author jerry7
 * @date 2021-01-11 16:39:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaAgencyApprovalReqVo", description = "")
public class TaAgencyApprovalReqVo extends PageVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("被代理人的岗位编码")
    private String fromPosCode;

    @ApiModelProperty("被代理人的岗位名称")
    private String fromPosName;

    @ApiModelProperty("被代理人的用户编码")
    private String fromUserCode;

    @ApiModelProperty("被代理人的用户名称")
    private String fromUserName;

    @ApiModelProperty("代理人的岗位编码")
    private String proxyPosCode;

    @ApiModelProperty("代理人的岗位名称")
    private String proxyPosName;

    @ApiModelProperty("代理人的用户编码")
    private String proxyUserCode;

    @ApiModelProperty("代理人的用户名称")
    private String proxyUserName;

    @ApiModelProperty("代理开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date proxyStartTime;

    @ApiModelProperty("代理结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date proxyEndTime;

    @ApiModelProperty("是否代理全部流程，0-否，1-是")
    private Integer allProxy;

    @ApiModelProperty("代理的流程key集合")
    private List<String> processKeyList;

    @ApiModelProperty("当前查询时间")
    private Date queryTime;

}