package com.biz.crm.nebular.dms.repfeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货补费用池产品VO
 * @Author: chenrong
 * @Date: 2020/12/3 20:20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "货补费用池产品VO")
public class RepFeePoolItemProductVo extends CrmExtVo {

  /**
   * 折扣费用池明细编码
   */
  @ApiModelProperty(value = "折扣费用池明细编码")
  private String repFeePoolItemCode;
  /**
   * 产品编码
   */
  @ApiModelProperty(value = "产品编码")
  private String productCode;
  /**
   * 产品名称
   */
  @ApiModelProperty(value = "产品名称")
  private String productName;
  /**
   * 产品规格
   */
  @ApiModelProperty("产品规格")
  private String spec;
  /**
   * 成本价
   */
  @ApiModelProperty(value = "成本价")
  private BigDecimal costPrice = BigDecimal.ZERO;
  /**
   * 销售价
   */
  @ApiModelProperty(value = "销售价")
  private BigDecimal salePrice = BigDecimal.ZERO;
}
