package com.biz.crm.nebular.mdm.material;

import com.biz.crm.common.ParamCheck;
import com.biz.crm.nebular.mdm.enums.ParamCheckTypeEnum;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

import java.io.Serializable;

/**
 * 物料管理导入vo
 * @author zxw
 */
@NebulaExcelImport(startRow = 1)
public class MdmMaterialImportExcelVo implements Serializable {

    @NebulaExcelColumn(order = 0, title = "物料编码")
    @ParamCheck(isNotNull = true, msg = "物料编码不能为空")
    private String materialCode;

    @NebulaExcelColumn(order = 1, title = "物料名称")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "物料名称不能为空", length = 64)
    private String materialName;

    @NebulaExcelColumn(order = 2, title = "产品层级编码")
    @ParamCheck(isNotNull = true, msg = "产品层级编码不能为空")
    private String productLevelCode;

    @NebulaExcelColumn(order = 3, title = "ai编码")
    @ParamCheck(isNotNull = false, checkType = {ParamCheckTypeEnum.LENGTH}, length = 128)
    private String aiCode;

    @NebulaExcelColumn(order = 4, title = "物料类型")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.DICT}, msg = "物料类型不能为空", dictType = "material_type")
    private String materialType;

    @NebulaExcelColumn(order = 5, title = "销售公司")
    @ParamCheck(isNotNull = false, checkType = {ParamCheckTypeEnum.DICT}, dictType = "sale_company")
    private String saleCompany;

    @NebulaExcelColumn(order = 6, title = "基本单位")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "基本单位不能为空", length = 128)
    private String baseUnit;

    @NebulaExcelColumn(order = 7, title = "销售单位")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "销售单位不能为空", length = 128)
    private String saleUnit;

    @NebulaExcelColumn(order = 8, title = "单位换算系数")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "单位换算不能为空", length = 128)
    private String unitConversion;

    @NebulaExcelColumn(order = 9, title = "规格")
    @ParamCheck(isNotNull = false, checkType = {ParamCheckTypeEnum.LENGTH}, length = 128)
    private String specification;

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getProductLevelCode() {
        return productLevelCode;
    }

    public void setProductLevelCode(String productLevelCode) {
        this.productLevelCode = productLevelCode;
    }

    public String getAiCode() {
        return aiCode;
    }

    public void setAiCode(String aiCode) {
        this.aiCode = aiCode;
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public String getSaleCompany() {
        return saleCompany;
    }

    public void setSaleCompany(String saleCompany) {
        this.saleCompany = saleCompany;
    }

    public String getBaseUnit() {
        return baseUnit;
    }

    public void setBaseUnit(String baseUnit) {
        this.baseUnit = baseUnit;
    }

    public String getSaleUnit() {
        return saleUnit;
    }

    public void setSaleUnit(String saleUnit) {
        this.saleUnit = saleUnit;
    }

    public String getUnitConversion() {
        return unitConversion;
    }

    public void setUnitConversion(String unitConversion) {
        this.unitConversion = unitConversion;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }


}
