package com.biz.crm.nebular.sfa.visitinfo.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 协访计划 请求vo
 *
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitAssistInfoReqVo", description = "协访计划 ")
public class SfaVisitAssistInfoReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("拜访计划编码")
    @SaturnColumn(description = "拜访计划编码")
    private String visitPlanCode;

    @ApiModelProperty("人员ID 人员ID")
    private String visitUserId;

    @ApiModelProperty("人员账号 人员账号")
    private String visitUserName;

    @ApiModelProperty("人员姓名 人员姓名")
    private String visitRealName;

    @ApiModelProperty("人员职位ID 人员职位ID")
    private String visitPosId;

    @ApiModelProperty("人员职位编码 人员职位编码")
    private String visitPosCode;

    @ApiModelProperty("人员职位名称 人员职位名称")
    private String visitPosName;

    @ApiModelProperty("人员所属组织ID 人员所属组织ID")
    private String visitOrgId;

    @ApiModelProperty("人员所属组织编码 人员所属组织编码")
    private String visitOrgCode;

    @ApiModelProperty("人员所属组织名称 人员所属组织名称")
    private String visitOrgName;

    @ApiModelProperty("协访日期 协访日期yyyy-MM-dd")
    private String visitDate;

    @ApiModelProperty("被协访的人员ID 被协访的人员ID")
    private String cvUserId;

    @ApiModelProperty("被协访的人员账号 被协访的人员账号")
    private String cvUserName;

    @ApiModelProperty("被协访的人员姓名 被协访的人员姓名")
    private String cvRealName;

    @ApiModelProperty("被协访的人员职位ID 被协访的人员职位ID")
    private String cvPosId;

    @ApiModelProperty("被协访的人员职位编码 被协访的人员职位编码")
    private String cvPosCode;

    @ApiModelProperty("被协访的人员职位名称 被协访的人员职位名称")
    private String cvPosName;

    @ApiModelProperty("被协访的人员所属组织ID 被协访的人员所属组织ID")
    private String cvOrgId;

    @ApiModelProperty("被协访的人员所属组织编码 被协访的人员所属组织编码")
    private String cvOrgCode;

    @ApiModelProperty("被协访的人员所属组织名称 被协访的人员所属组织名称")
    private String cvOrgName;

    @ApiModelProperty("网点id 协访网点")
    private String clientId;

    @ApiModelProperty("网点编码 协访网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称 协访网点名称")
    private String clientName;

    @ApiModelProperty("网点类型 协访网点类型")
    private String clientType;

    @ApiModelProperty("网点地址;协访网点地址")
    private String clientAddress;

    @ApiModelProperty("经度 协访网点经度")
    private BigDecimal longitude;

    @ApiModelProperty("纬度 协访网点纬度")
    private BigDecimal latitude;

    @ApiModelProperty("距离hash值 协访网点hash值")
    private String geohash;

    @ApiModelProperty("状态 拜访状态")
    private String visitStatus;

}