package com.biz.crm.nebular.dms.repfeepool;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Author: chenrong
 * @Date: 2021/1/27 16:16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RepFeePoolAdjustFeeVo implements Serializable {

  private static final long serialVersionUID = 5184666943679555258L;

  /**
   * 商品编码
   */
  @ApiModelProperty(value = "商品编码")
  private String productCode;
  /**
   * 调整成本金额
   */
  @ApiModelProperty(value = "调整成本金额")
  private BigDecimal adjustCostFee = BigDecimal.ZERO;
  /**
   * 调整销售金额
   */
  @ApiModelProperty(value = "调整销售金额")
  private BigDecimal adjustSaleFee = BigDecimal.ZERO;
  /**
   * 调整计算金额
   */
  @ApiModelProperty(value = "调整计算金额")
  private BigDecimal adjustFee = BigDecimal.ZERO;
}
