package com.biz.crm.nebular.activiti.act.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author weston
 * @date 2020-12-12
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "TaskOptReqVO", description = "节点操作请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class TaskOptReqVO {

    @ApiModelProperty(value = "节点ID", required = true)
    private String taskId;

    @ApiModelProperty(value = "操作按钮编码", required = true)
    private String optBtnCode;

    @ApiModelProperty(value = "业务参数JSON字符串(非必填)")
    private String businessData;

    @ApiModelProperty(value = "流程参数:JSON字符串(非必填)")
    private String taskVariables;

    @ApiModelProperty(value = "备注(非必填)")
    private String remark;

    @ApiModelProperty(value = "审批提交文件集合")
    private List<TaActFileReqVo> fileList;
}
