package com.bizunited.platform.kuiper.starter.common.excel;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Nebula Excel 导出注解
 *
 * @author Keller
 * @create 2020/8/25
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface NebulaExcelExport {

  /**
   * 导出数据查询分页大小
   *
   * @return
   */
  int pageSize() default 1000;

  /**
   * 定义导出文件名
   */
  String excelName() default "";

  /**
   * 定义导出sheet名称
   */
  String sheetName() default "数据";
}
