package com.biz.crm.nebular.dms.rebatefeepool;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/10/21 16:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "前段页面查询上账记录的vo")
public class ListFeeReq extends PageVo {

    @ApiModelProperty(value = "开始时间（yyyy-MM-dd）")
    private String startDate;

    @ApiModelProperty(value = "结束时间（yyyy-MM-dd）")
    private String endDate;

    @ApiModelProperty(value = "销售公司编码")
    private String salesCompaneyCode;

    public static ListFeeReq newInstance(String salesCompaneyCode,String startDate,String endDate) {
        ListFeeReq listFeeReq = new ListFeeReq();
        listFeeReq.setSalesCompaneyCode(salesCompaneyCode);
        listFeeReq.setStartDate(startDate);
        listFeeReq.setEndDate(endDate);
        listFeeReq.setPageNum(1);
        listFeeReq.setPageSize(4000);
        return listFeeReq;
    }
}
