package com.biz.crm.nebular.dms.repfeepool;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/24 16:30
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "货补费用池汇总vo")
public class RepItemReflushVo implements Serializable {

    /**
     * 上账数量
     */
    private BigDecimal onAccountCount = BigDecimal.ZERO;

    /**
     * 上账金额
     */
    private BigDecimal onAccountFee = BigDecimal.ZERO;

    /**
     * 已使用数量
     */
    private BigDecimal usedCount = BigDecimal.ZERO;

    /**
     * 已使用金额
     */
    private BigDecimal usedFee = BigDecimal.ZERO;

    /**
     * 冻结数量
     */
    private BigDecimal frozenCount = BigDecimal.ZERO;

    /**
     * 冻结金额
     */
    private BigDecimal frozenFee = BigDecimal.ZERO;

    /**
     * 可用数量
     */
    private BigDecimal availableCount = BigDecimal.ZERO;

    /**
     * 可用金额
     */
    private BigDecimal availableFee = BigDecimal.ZERO;



    /**
     * 待提交数量(add)
     */
    private BigDecimal toSubmitNum = BigDecimal.ZERO;

    /**
     * 待提交金额(add)
     */
    private BigDecimal toSubmitFee = BigDecimal.ZERO;

    /**
     * 待审核数量(add)
     */
    private BigDecimal toExamineNum = BigDecimal.ZERO;

    /**
     * 待审核金额(add)
     */
    private BigDecimal toExamineFee = BigDecimal.ZERO;

    /**
     * 占用金额
     */
    private BigDecimal occupyFee = BigDecimal.ZERO;

    /**
     * 占用数量
     */
    private BigDecimal occupyNum = BigDecimal.ZERO;

    /**
     * 金额
     */
    private BigDecimal fee;
    /**
     * 成本金额
     */
    private BigDecimal costFee;

    /**
     * 数量
     */
    private BigDecimal num;

    /**
     * 审核状态
     */
    private Integer bpmState;

    /**
     * 调整类型
     */
    private Integer adjustType;

    //上账成本金额
    private BigDecimal onAccountCostFee = BigDecimal.ZERO;
    //可使用成本金额
    private BigDecimal availableCostFee = BigDecimal.ZERO;
    //已使用成本金额
    private BigDecimal usedCostFee = BigDecimal.ZERO;
    //冻结成本金额
    private BigDecimal frozenCostFee = BigDecimal.ZERO;
    //待提交成本金额
    private BigDecimal toSubmitCostFee = BigDecimal.ZERO;
    //待审核成本金额
    private BigDecimal toExamineCostFee = BigDecimal.ZERO;
    //占用成本金额
    private BigDecimal occupyCostFee = BigDecimal.ZERO;
}
