package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用池明细表请求vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDetailReqVo", description = "费用池明细表")
public class FeePoolDetailReqVo extends CrmExtTenVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("费用池明细编号")
    private String poolDetailCode;

    @ApiModelProperty("操作记录编号")
    private String operationCode;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("来源编号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("上账时间yyyy-MM-dd HH:mm:ss")
    private String accountDateTime;

    @ApiModelProperty("上账金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("冻结金额")
    private BigDecimal freezeAmount;

    @ApiModelProperty("已使用")
    private BigDecimal useAmount;

    @ApiModelProperty("剩余可使用金额")
    private BigDecimal usableAmount;

}