package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 货补费用池添加期初请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolGoodsInitAccountReqVo", description = "货补费用池添加期初请求VO")
public class FeePoolGoodsInitAccountReqVo extends CrmExtTenVo {

    @ApiModelProperty("审批状态")
    private String bpmStatus;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("货补产品层级编码")
    private String goodsProductLevelCode;

    @ApiModelProperty("货补产品层级名称")
    private String goodsProductLevelName;

    @ApiModelProperty("货补商品编码(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductCode;

    @ApiModelProperty("货补商品名称(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductName;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("总金额")
    private BigDecimal amount;

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;

}