package com.biz.crm.nebular.fee.pool.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用池明细日志表返回vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用池明细日志表")
public class FeePoolDetailLogRespVo extends CrmBaseVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("费用池明细编号")
    private String poolDetailCode;

    @ApiModelProperty("操作记录编号")
    private String operationCode;

    @ApiModelProperty("上账类型")
    private String operationType;

    @ApiModelProperty("来源编号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("金额")
    private BigDecimal operationAmount;

    @ApiModelProperty("金额权重 1或者-1")
    private BigDecimal amountWeight;

}