package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 货补费用池使用请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolGoodsUseReqVo", description = "货补费用池使用请求VO")
public class FeePoolGoodsUseReqVo {

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("使用金额明细")
    private List<FeePoolGoodsUseItemReqVo> poolAmountList;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;
}