package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.config.CrmDict;
import com.biz.crm.config.CrmSetVal;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.enums.CustomerDefaultAddressEnum;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.ehcache.core.internal.util.TypeUtil;

/**
 * 客户信息：收货地址返回vo
 *
 * @author zxw
 * @date 2020-09-10 12:09:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户信息：收货地址")
@SaturnEntity(name = "MdmCustomerAddressRespVo", description = "客户信息：收货地址")
public class MdmCustomerAddressRespVo extends CrmExtVo {

    @ApiModelProperty("市")
    @SaturnColumn(description = "市")
    private String cityCode;

    @ApiModelProperty("区")
    @SaturnColumn(description = "区")
    private String districtCode;

    @ApiModelProperty("省")
    @SaturnColumn(description = "省")
    private String provinceCode;

    @ApiModelProperty("送达方编码")
    @SaturnColumn(description = "送达方编码")
    private String destinationCode;

    @ApiModelProperty("送达方名称")
    @SaturnColumn(description = "送达方名称")
    private String destinationName;

    @ApiModelProperty("市名称")
    @SaturnColumn(description = "市名称")
    private String cityName;

    @ApiModelProperty("省名称")
    @SaturnColumn(description = "省名称")
    private String provinceName;

    @ApiModelProperty("区名称")
    @SaturnColumn(description = "区名称")
    private String districtName;

    @ApiModelProperty("详细地址")
    @SaturnColumn(description = "详细地址")
    private String detailedAddress;

    @ApiModelProperty("联系人")
    @SaturnColumn(description = "联系人")
    private String contactName;

    @ApiModelProperty("联系电话")
    @SaturnColumn(description = "联系电话")
    private String contactPhone;

    @ApiModelProperty("是否默认地址")
    @SaturnColumn(description = "是否默认地址")
    private String defaultAddress;

    @ApiModelProperty("是否默认地址名称（数据字典：customer_default_addr）")
    @CrmDict(typeCode = "customer_default_addr",dictCodeField = "defaultAddress")
    private String defaultAddressName;

    @ApiModelProperty("有效开始时间")
    private String startTime;

    @ApiModelProperty("有效结束时间")
    private String endTime;

}