package com.biz.crm.nebular.activiti.design.req;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

/**
 * @author weston
 * @date 2020-12-03
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "TaProcessInfoReqVO", description = "流程基本信息请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class TaProcessInfoReqVO extends PageVo {

    @ApiModelProperty(value = "流程定义KEY", required = false)
    private String processKey;

    @ApiModelProperty(value = "流程定义名称", required = false)
    private String processName;

    @ApiModelProperty(value = "流程状态(0=未发布1=已发布)", required = false)
    private Integer processState;

    @ApiModelProperty(value = "流程状态")
    private String processStateDesc;
}
