package com.biz.crm.nebular.log;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 18:07
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CrmLogDto implements Serializable {

    /**
     * 操作类型Code
     */
    private Integer operationType;

    /**
     * 记录唯一键（一般是id）
     */
    private String onlyKey;

    /**
     * 记录唯一描述（用于搜索）
     */
    private String onlyKeyDes;

    /**
     * 日志模板编码
     */
    private String menuCode;

    /**
     * 更新之前的对象
     */
    private Object oldObject;

    /**
     * 更新之后的对象
     */
    private Object newObject;

    /**
     * 操作人id
     */
    private String operationUserId;

    /**
     * 操作人姓名
     */
    private String operationUserName;

    /**
     * 操作时间
     */
    private String operationTime;

    public CrmLogDto(String menuCode, Integer operationType, String onlyKey,Object oldObject, Object newObject, String operationUserId, String operationUserName) {
        this.operationType = operationType;
        this.onlyKey = onlyKey;
        this.menuCode = menuCode;
        this.oldObject = oldObject;
        this.newObject = newObject;
        this.operationUserId = operationUserId;
        this.operationUserName = operationUserName;
    }


    public CrmLogDto(Integer operationType, String onlyKey, String menuCode, Object oldObject, Object newObject, String operationUserId, String operationUserName) {
        this.operationType = operationType;
        this.onlyKey = onlyKey;
        this.menuCode = menuCode;
        this.oldObject = oldObject;
        this.newObject = newObject;
        this.operationUserId = operationUserId;
        this.operationUserName = operationUserName;
    }

    public CrmLogDto(Integer operationType, String onlyKey, String onlyKeyDes, String menuCode, Object oldObject, Object newObject, String operationUserId, String operationUserName) {
        this.operationType = operationType;
        this.onlyKey = onlyKey;
        this.onlyKeyDes = onlyKeyDes;
        this.menuCode = menuCode;
        this.oldObject = oldObject;
        this.newObject = newObject;
        this.operationUserId = operationUserId;
        this.operationUserName = operationUserName;
    }
}
