package com.biz.crm.nebular.mdm.mdmbuglistmanagement.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * bug管理主表返回vo
 *
 * @author lf
 * @date 2021-01-29 11:23:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "bug管理主表")
@CrmColumnResolve
public class MdmBugListManagementRespVo extends CrmBaseVo {
    @ApiModelProperty("禅道bug编号")
    private String bugCode;

    @ApiModelProperty("bug名称")
    private String bugName;

    @ApiModelProperty("bug负责人")
    private String chargeMan;

    @ApiModelProperty("是否已完成(发布到远程仓库后,该字段值为Y,默认为N)")
    private String isComplete;

    @ApiModelProperty("是否已完成(发布到远程仓库后))")
    private String isCompleteDesc;

    @ApiModelProperty("后端是否已解决(Y,N)")
    private String isBackendFix;

    @ApiModelProperty("后端是否已解决(是,否)")
    private String isBackendFixDesc;

    @ApiModelProperty("前端是否已解决(Y,N)")
    private String isForeEndFix;

    @ApiModelProperty("前端是否已解决")
    private String isForeEndFixDesc;

    @ApiModelProperty("是否dev测试中(Y,N)")
    private String isDevTesting;

    @ApiModelProperty("是否dev测试中")
    private String isDevTestingDesc;

    @ApiModelProperty("dev是否测试通过(Y,N)")
    private String isDevPassTest;

    @ApiModelProperty("dev是否测试通过")
    private String isDevPassTestDesc;

    @ApiModelProperty("后端是否已部署(Y,N)")
    private String isBackendArrUat;

    @ApiModelProperty("后端是否已部署")
    private String isBackendArrUatDesc;

    @ApiModelProperty("前端是否已部署uat(Y,N)")
    private String isForeEndArrUat;

    @ApiModelProperty("前端是否已部署uat")
    private String isForeEndArrUatDesc;

    @ApiModelProperty("uat 测试中(Y,N)")
    private String isUatTesting;

    @ApiModelProperty("uat 测试中")
    private String isUatTestingDesc;

    @ApiModelProperty("uat 测试通过(Y,N)")
    private String isUatPassTest;

    @ApiModelProperty("uat 测试通过")
    private String isUatPassTestDesc;

    @ApiModelProperty("后端是否已部署 pro(Y,N)")
    private String isBackendArrPro;

    @ApiModelProperty("后端是否已部署 pro")
    private String isBackendArrProDesc;

    @ApiModelProperty("前端是否已部署(Y,N)")
    private String isForeEndArrPro;

    @ApiModelProperty("前端是否已部署")
    private String isForeEndArrProDesc;

    @ApiModelProperty("pro 测试中(Y,N)")
    private String isProTesting;

    @ApiModelProperty("pro 测试中")
    private String isProTestingDesc;

    @ApiModelProperty("pro测试通过")
    private String isProPassTest;

    @ApiModelProperty("pro测试通过")
    private String isProPassTestDesc;
}