package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 货补费用池使用金额明细请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolGoodsUseItemReqVo", description = "货补费用池使用金额明细请求VO")
public class FeePoolGoodsUseItemReqVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("使用金额")
    private BigDecimal amount;

}