package com.biz.crm.nebular.sfa.worksignrule.req;

import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignRuleVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 考勤规则;考勤规则请求vo
 *
 * @author liuhongming
 * @date 2020-09-16 14:50:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSignRuleReqVo", description = "考勤规则;考勤规则")
public class SfaWorkSignRuleReqVo extends SfaWorkSignRuleVo {
    private List<String> ids;
    /**
     * 规则生效日期;规则生效日期(1:立即生效/2:明日生效)
     */
    @ApiModelProperty("规则生效日期(NOW:立即生效/TOMORROW:明日生效) 默认明日")
    private String ruleEffective;
    @ApiModelProperty("规则编码集合;")
    private List<String> ruleCodes;
    @ApiModelProperty("考勤规则-打卡人员")
    private List<SfaWorkSignPersonnelReqVo> sfaWorkSignPersonnelReqVo;
    @ApiModelProperty("考勤规则-打卡地点")
    private List<SfaWorkSignPlaceReqVo> sfaWorkSignPlaceReqVos;
    @ApiModelProperty("考勤规则-打卡时间")
    private List<SfaWorkSignTimeReqVo> sfaWorkSignTimeReqVos;
    @ApiModelProperty("考勤规则-特殊日期 必须打卡的日期")
    private List<SfaWorkSignSpecialReqVo> sfaWorkSignSpecialMustReqVos;
    @ApiModelProperty("考勤规则-特殊日期 不用打卡的日期")
    private List<SfaWorkSignSpecialReqVo> sfaWorkSignSpecialNotReqVos;


}