package com.biz.crm.nebular.tpm.income.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 收入预算;返回vo
 *
 * @author lf
 * @date 2021-02-02 17:55:15
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "收入预算;")
@SaturnEntity(name = "TpmIncomeBudgetRespVo", description = "收入预算;")
public class TpmIncomeBudgetRespVo extends CrmExtVo {
    @ApiModelProperty("岗位编码;岗位编码")
    @SaturnColumn(description = "岗位编码;岗位编码")
    private String positionCode;

    @ApiModelProperty("岗位名称;岗位名称")
    @SaturnColumn(description = "岗位名称;岗位名称")
    private String positionName;

    @ApiModelProperty("备注说明;备注说明")
    @SaturnColumn(description = "备注说明;备注说明")
    private String notes;

    @ApiModelProperty("预算编码;预算编码")
    @SaturnColumn(description = "预算编码;预算编码")
    private String budgetCode;

    @ApiModelProperty("预算名称;预算名称")
    @SaturnColumn(description = "预算名称;预算名称")
    private String budgetName;

    @ApiModelProperty("年;年")
    @SaturnColumn(description = "年;年")
    private String budgetYear;

    @ApiModelProperty("月份;月份")
    @SaturnColumn(description = "月份;月份")
    private String budgetMonth;

    @ApiModelProperty("年月;年月")
    @SaturnColumn(description = "年月;年月")
    private String budgetYearMonth;

    @ApiModelProperty("组织编码;组织编码")
    @SaturnColumn(description = "组织编码;组织编码")
    private String budgetDepartCode;

    @ApiModelProperty("组织ID;组织ID")
    @SaturnColumn(description = "组织ID;组织ID")
    private String budgetDepartId;

    @ApiModelProperty("组织;组织")
    @SaturnColumn(description = "组织;组织")
    private String budgetDepartName;

    @ApiModelProperty("产品编码;产品编码")
    @SaturnColumn(description = "产品编码;产品编码")
    private String productCode;

    @ApiModelProperty("产品;产品")
    @SaturnColumn(description = "产品;产品")
    private String productName;

    @ApiModelProperty("分组编码;分组编码")
    @SaturnColumn(description = "分组编码;分组编码")
    private String subjectsGroupCode;

    @ApiModelProperty("分组;分组")
    @SaturnColumn(description = "分组;分组")
    private String subjectsGroupName;

    @ApiModelProperty("客户编码;客户编码")
    @SaturnColumn(description = "客户编码;客户编码")
    private String custCode;

    @ApiModelProperty("客户;客户")
    @SaturnColumn(description = "客户;客户")
    private String custName;

    @ApiModelProperty("门店编码;门店编码")
    @SaturnColumn(description = "门店编码;门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称;门店名称")
    @SaturnColumn(description = "门店名称;门店名称")
    private String terminalName;

    @ApiModelProperty("预算科目编码;预算科目编码")
    @SaturnColumn(description = "预算科目编码;预算科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("预算科目名称;预算科目名称")
    @SaturnColumn(description = "预算科目名称;预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("期初金额;期初金额")
    @SaturnColumn(description = "期初金额;期初金额")
    private BigDecimal initAmount;

    @ApiModelProperty("当前余额;当前余额")
    @SaturnColumn(description = "当前余额;当前余额")
    private BigDecimal amount;

    @ApiModelProperty("产品层级编码")
    @SaturnColumn(description = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    @SaturnColumn(description = "产品层级名称")
    private String productLevelName;

    @ApiModelProperty("收入预算类型")
    @SaturnColumn(description = "收入预算类型")
    private String budgetType;

    @ApiModelProperty("业务选择的职位编码")
    @SaturnColumn(description = "业务选择的职位编码")
    private String posCode;

    @ApiModelProperty("业务选择的职位名称")
    @SaturnColumn(description = "业务选择的职位名称")
    private String posName;

    @ApiModelProperty("客户组织编码")
    @SaturnColumn(description = "客户组织编码")
    private String custOrgCode;

    @ApiModelProperty("客户组织名称")
    @SaturnColumn(description = "客户组织名称")
    private String custOrgName;

}