package com.biz.crm.nebular.mdm.productlevel.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 返回vo
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@Data
@ApiModel(value = "MdmProductLevelRespVo", description = "产品层级")
public class MdmProductLevelRespVo extends CrmTreeVo {

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品层级类型")
    private String productLevelType;

    @ApiModelProperty("产品层级类型名称")
    @CrmDict(typeCode = "mdm_product_level_type", dictCodeField = "productLevelType")
    private String productLevelTypeName;

    @ApiModelProperty("上级产品层级名称")
    private String parentName;

    @ApiModelProperty("上级产品层级编码")
    private String parentCode;

}