package com.biz.crm.nebular.sfa.visitinfo.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 拜访进度 返回vo
 *
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访进度")
@SaturnEntity(name = "SfaVisitProgressRespVo", description = "拜访进度 ")
public class SfaVisitProgressRespVo extends CrmExtVo {

    @ApiModelProperty("已完成拜访数量")
    @SaturnColumn(description = "已完成拜访数量")
    private Integer complete;

    @ApiModelProperty("是否有拜访中网点")
    @SaturnColumn(description = "是否有拜访中网点")
    private Boolean inProgress = false;

    @ApiModelProperty("拜访中的网点id")
    @SaturnColumn(description = "拜访中的网点id")
    private String clientId;

    @ApiModelProperty("拜访中的网点编码")
    @SaturnColumn(description = "拜访中的网点编码")
    private String clientCode;

    @ApiModelProperty("拜访中的网点名称")
    @SaturnColumn(description = "拜访中的网点名称")
    private String clientName;

    @ApiModelProperty("拜访中的网点类型")
    @SaturnColumn(description = "拜访中的网点类型")
    private String clientType;

    @ApiModelProperty("当日拜访总数量")
    private Integer visitTotalNum;

}