package com.biz.crm.nebular.dms.order;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: huojia
 * @DateTime: 2021/1/28 19:05
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "订单主信息的vo")
public class OrderVo extends CrmExtVo {

    //------------------订单基本信息----------------------

    /**
     * 订单编号
     */
    @ApiModelProperty(value = "订单编号")
    private String orderCode;

    /**
     * 订单来源编号
     */
    @ApiModelProperty(value = "订单来源编号")
    private String sourceCode;

    /**
     * 订单类型
     */
    @ApiModelProperty(value = "订单类型")
    private String type;

    /**
     * 订单状态
     */
    @ApiModelProperty(value = "订单状态")
    private String state;

    //--------------------订单商品相关信息------------------------

    /**
     * 订单总重量(克)
     */
    @ApiModelProperty(value = "订单总重量(克)")
    private BigDecimal weightOfGram;

    /**
     * 订单总重量(千克)
     */
    @ApiModelProperty(value = "订单总重量(千克)")
    private BigDecimal weightOfKilogram;

    /**
     * 订单总重量(吨)
     */
    @ApiModelProperty(value = "订单总重量(吨)")
    private BigDecimal weightOfTon;

    /**
     * 商品总数量
     */
    @ApiModelProperty(value = "商品总数量")
    private BigDecimal productNum;

    //--------------------------订单金额---------------------------------

    /**
     * 订单总金额
     */
    @ApiModelProperty(value = "订单总金额")
    private BigDecimal amount;

    /**
     * 订单促销优惠金额
     */
    @ApiModelProperty(value = "订单促销优惠金额")
    private BigDecimal promotionAmount;

    /**
     * 订单折扣费用使用金额
     */
    @ApiModelProperty(value = "订单折扣费用使用金额")
    private BigDecimal discountAmount;

    /**
     * 订单货补费用使用金额
     */
    @ApiModelProperty(value = "订单货补费用使用金额")
    private BigDecimal repAmount;

    /**
     * 订单货补费用使用金额
     */
    @ApiModelProperty(value = "订单货补费用使用金额")
    private BigDecimal actualAmount;

    //-------------------------交货信息---------------------------

    /**
     * 提货方式
     */
    @ApiModelProperty(value = "提货方式")
    private String pickType;

    /**
     * 收货地址
     */
    @ApiModelProperty(value = "收货地址")
    private String pickAdress;

    /**
     * 联系人姓名
     */
    @ApiModelProperty(value = "联系人姓名")
    private String contactsName;

    /**
     * 联系人电话
     */
    @ApiModelProperty(value = "联系人电话")
    private String contactsPhone;

    /**
     * 交货日期(yyyy-MM-dd HH:mm:ss)
     */
    @ApiModelProperty(value = "交货日期(yyyy-MM-dd HH:mm:ss)")
    private String giveDate;

    //----------------------客户信息-------------------------

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String cusCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String cusName;

    /**
     * 客户组织编码
     */
    @ApiModelProperty(value = "客户组织编码")
    private String cusOrgCode;

    /**
     * 客户组织名称
     */
    @ApiModelProperty(value = "客户组织名称")
    private String cusOrgName;

    @ApiModelProperty(value = "订单明细")
    private List<OrderDetailVo> detailVos;

}