package com.biz.crm.nebular.dms.salecontract;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 合同模板vo
 * @Author: chenrong
 * @Date: 2021/2/5 10:54
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "合同模板vo")
public class ContractTemplateVo extends CrmExtTenVo {

  private static final long serialVersionUID = 5711197545706458946L;

  /**
   * 合同模板编码
   */
  private String code;
  /**
   * 合同类型
   */
  private Integer contractType;
  /**
   * 组织编码
   */
  private String orgCode;
  /**
   * 组织名称
   */
  private String orgName;
  /**
   * 开始时间
   */
  private String startTime;
  /**
   * 结束时间
   */
  private String endTime;
  /**
   * 合同元组列表
   */
  private List<ContractTupleVo> tuples;

}
