package com.biz.crm.nebular.dms.salecontract;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 合同元组vo
 * @Author: chenrong
 * @Date: 2021/2/5 10:01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "合同元组vo")
public class ContractTupleVo extends CrmExtTenVo {

  private static final long serialVersionUID = -8927879069200640589L;

  /**
   * 编码
   */
  private String code;
  /**
   * 名称
   */
  private String name;
  /**
   * 前端项目中的相对路径
   */
  private String relativePath;
  /**
   * 前端路由路径
   */
  private String routerPath;
  /**
   * 对象字段名
   */
  private String jsonName;
  /**
   * 逻辑处理bean（该模块数据保存和查询）名称
   */
  private String beanName;
  /**
   * 元组在模板中的展示顺序
   */
  private Integer index;
}
