package com.biz.crm.nebular.mdm.product.req;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 请求vo
 *
 * @author crm
 * @date 2020-08-27 16:29:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@CrmColumnResolve
public class MdmProductMaterialReqVo extends CrmExtTenVo {


    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("物料数量")
    private Integer count;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    private String materialName;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("比例")
    private BigDecimal ratio;

}
