package com.biz.crm.nebular.activiti.start.req;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author weston
 * @date 2020-11-25
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "StartProcessReqVO", description = "移动端发起流程请求VO")
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class CancelProcessReqVO {

    @ApiModelProperty(value = "业务表单单号", required = true)
    private String formNo;

    @ApiModelProperty(value = "发起人编码", required = true)
    private String userCode;

    @ApiModelProperty(value = "表单类型")
    private String costType;

    @ApiModelProperty(value = "发起流程来源业务系统")
    private String formType;

    @ApiModelProperty("表单类型二级编码")
    private String smallType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("任务ID")
    private String taskId;

    @ApiModelProperty("流程实例ID")
    private String processInstId;

    public CancelProcessReqVO(String formNo, String userCode, String costType, String formType) {
        this.formNo = formNo;
        this.userCode = userCode;
        this.costType = costType;
        this.formType = formType;
    }
}
