package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/2 15:40
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "查询组织列表的参数")
@SaturnEntity(name = "ListOrg", description = "查询组织列表的参数")
public class ListOrg extends PageVo {

    @ApiModelProperty(value = "组织机构的唯一编号")
    @SaturnColumn(description = "组织机构的唯一编号")
    private String code;

    @ApiModelProperty(value = "组织机构名称")
    @SaturnColumn(description = "组织机构名称")
    private String orgName;

    @ApiModelProperty(value = "父组织id")
    @SaturnColumn(description = "父组织id")
    private String parentId;

    @ApiModelProperty(value = "组织机构类型(0:部门,1:单位)")
    @SaturnColumn(description = "组织机构类型(0:部门,1:单位)")
    private Integer type;

    @ApiModelProperty(value = "组织机构描述")
    @SaturnColumn(description = "组织机构描述")
    private String description;

    @ApiModelProperty(value = "组织机构排序")
    @SaturnColumn(description = "组织机构排序")
    private Integer sortIndex;

    @ApiModelProperty(value = "创建时间")
    @SaturnColumn(description = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "正常,不正常(1,0)")
    @SaturnColumn(description = "正常,不正常(1,0)")
    private Integer tstatus;

    @ApiModelProperty(value = "是否是叶子节点")
    @SaturnColumn(description = "是否是叶子节点")
    private Boolean isLeaf;

}
