package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 用户信息表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserEditReqVo", description = "用户新增编辑请求VO")
public class MdmUserEditReqVo extends CrmExtTenVo {

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("角色编码")
    private String roleCode;

    @Deprecated
    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("密码（经过加密的）")
    private String userPassword;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间")
    private String endTime;

    @ApiModelProperty("失效时间")
    private String startTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("职位列表")
    private List<MdmUserPositionEditReqVo> positionList;

    @ApiModelProperty("客户列表")
    private List<MdmUserCustomerEditReqVo> customerList;

    @ApiModelProperty("企业用户冗余关联的职位编码集合（英文逗号间隔）")
    @Deprecated
    private String positionCodeRedundancy;

    @ApiModelProperty("企业用户冗余关联的职位名称集合（英文逗号间隔）")
    @Deprecated
    private String positionNameRedundancy;

    @ApiModelProperty("客户用户冗余客户编码集合（英文逗号间隔）")
    @Deprecated
    private String customerCodeRedundancy;

    @ApiModelProperty("客户用户冗余客户名称集合（英文逗号间隔）")
    @Deprecated
    private String customerNameRedundancy;

    @ApiModelProperty("用户头像url")
    private String userHeadUrl;

}