package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.common.ParamCheck;
import com.biz.crm.nebular.mdm.enums.ParamCheckTypeEnum;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;
import lombok.Data;

/**
 * @author zxw
 */
@NebulaExcelImport(startRow = 1)
public class MdmCustomerMsgImportExcelVo {


    @NebulaExcelColumn(order = 0, title = "客户名称")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "客户名称不能为空", length = 64)
    private String customerName;

    @NebulaExcelColumn(order = 1, title = "客户类型")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.DICT}, msg = "客户类型不能为空", dictType = "customer_type")
    private String customerType;

    @NebulaExcelColumn(order = 2, title = "所属组织编码")
    @ParamCheck(isNotNull = true, msg = "所属组织编码不能为空")
    private String orgCode;

    @NebulaExcelColumn(order = 3, title = "客户组织编码")
    @ParamCheck(isNotNull = true, msg = "客户组织编码不能为空")
    private String customerOrgCode;

    @NebulaExcelColumn(order = 4, title = "渠道")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.DICT}, msg = "渠道不能为空", dictType = "channel")
    private String channel;

    @NebulaExcelColumn(order = 5, title = "省")
    @ParamCheck(isNotNull = true, msg = "省份不能为空")
    private String provinceCode;

    @NebulaExcelColumn(order = 6, title = "市")
    @ParamCheck(isNotNull = true, msg = "市区不能为空")
    private String cityCode;

    @NebulaExcelColumn(order = 7, title = "区")
    @ParamCheck(isNotNull = true, msg = "区/县不能为空")
    private String districtCode;

    @NebulaExcelColumn(order = 8, title = "客户法人代表")
    @ParamCheck(isNotNull = false)
    private String legalRepresentative;

    @NebulaExcelColumn(order = 9, title = "客户联系方式")
    @ParamCheck(isNotNull = false)
    private String customerContact;

    @NebulaExcelColumn(order = 10, title = "注册地址")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "注册地址不能为空", length = 128)
    private String registeredAddress;

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerType() {
        return customerType;
    }

    public void setCustomerType(String customerType) {
        this.customerType = customerType;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getCustomerOrgCode() {
        return customerOrgCode;
    }

    public void setCustomerOrgCode(String customerOrgCode) {
        this.customerOrgCode = customerOrgCode;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getLegalRepresentative() {
        return legalRepresentative;
    }

    public void setLegalRepresentative(String legalRepresentative) {
        this.legalRepresentative = legalRepresentative;
    }

    public String getCustomerContact() {
        return customerContact;
    }

    public void setCustomerContact(String customerContact) {
        this.customerContact = customerContact;
    }

    public String getRegisteredAddress() {
        return registeredAddress;
    }

    public void setRegisteredAddress(String registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    @Override
    public String toString() {
        return "MdmCustomerMsgImportExcelVo{" +
            "customerName='" + customerName + '\'' +
            ", customerType='" + customerType + '\'' +
            ", orgCode='" + orgCode + '\'' +
            ", customerOrgCode='" + customerOrgCode + '\'' +
            ", channel='" + channel + '\'' +
            ", provinceCode='" + provinceCode + '\'' +
            ", cityCode='" + cityCode + '\'' +
            ", districtCode='" + districtCode + '\'' +
            ", legalRepresentative='" + legalRepresentative + '\'' +
            ", customerContact='" + customerContact + '\'' +
            ", registeredAddress='" + registeredAddress + '\'' +
            '}';
    }
}
