package com.biz.crm.nebular.activiti.common.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.PageVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @CLASS_DESCRIBE: 我的流程 请求vo
 * @AUTHOR: create by zkey on 2020-11-04
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivitiCommonRespVo", description = "流程respvo")
@CrmColumnResolve
public class ActivitiCommonRespVo extends PageVo {


    @ApiModelProperty("流程名称")
    private String modelName;

    @ApiModelProperty("流程主题")
    private String title;

    @ApiModelProperty("流程状态")
    @CrmDict(typeCode = "bpm_status",dictCodeField = "bpm_status")
    private String bpmStatus;

    @ApiModelProperty("业务编码")
    private String businessId;

    @ApiModelProperty("耗时")
    private String consumingTime;

    @ApiModelProperty("启动时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty("结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty("流程实例ID")
    private String processInstanceId;

    @ApiModelProperty("节点名称")
    private String nodeName;

    @ApiModelProperty("任务发起人")
    private String startUser;

    @ApiModelProperty("发起人部门")
    private String startOrgName;

}
