package com.biz.crm.nebular.activiti.start.req;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.Map;

/**
 * @CLASS_DESCRIBE: 流程启动时 请求参数vo
 * @AUTHOR: create by zkey on 2020-11-02
 */
@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivitiStartInfoReqVo", description = "流程启动信息vo")
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class ActivitiStartInfoReqVo extends PageVo {

    @ApiModelProperty("提交主题")
    private String title;//提交主题

    @ApiModelProperty("提交详情")
    private String detail;//提交详情

    @ApiModelProperty("启动人")
    private String startUser;//启动人

    @ApiModelProperty("启动时间")
    private Date startTime;//启动时间

    @ApiModelProperty("流程模型id")
    private String modelId;//流程模型id

    @ApiModelProperty("流程模型名称")
    private String modelName;//流程模型名称

    @ApiModelProperty("流程实例ID")
    private String processInstanceId;//流程实例ID

    @ApiModelProperty("业务ID")
    private String businessId;//业务ID

    //@ApiModelProperty("流程附件")
    //private List<String> attachments;//流程附件

    @ApiModelProperty("流程变量")
    private Map<String,Object> variable;//流程变量

    @ApiModelProperty("启动人职位编码")
    private String startPositionCode;//启动人职位编码

    @ApiModelProperty("审批状态")
    private String bpmStatus;//审批状态

    @ApiModelProperty("操作人职位编码")
    private String optPositionCode;//操作人职位编码

    @ApiModelProperty("发起人组织编码")
    private String startOrgCode;//发起人组织编码
}
