package com.biz.crm.nebular.mdm.pricesetting.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 条件字段类型主表 请求vo
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPriceConditionTypeReqVo", description = "条件字段类型主表 ")
public class MdmPriceConditionTypeReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("条件字段类型编码")
    private String conditionTypeCode;

    @ApiModelProperty("条件字段类型描述")
    private String conditionTypeDesc;

    @ApiModelProperty("抬头/行项目（数据字典condition_type_type）")
    private String conditionTypeType;

    @ApiModelProperty("条件类型分类关联集合")
    private List<MdmPriceConditionTypeRelGroupReqVo> conditionTypeRelGroupReqVoList;

}