package com.biz.crm.nebular.mdm.user.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 用户新增编辑选择已有职位请求VO
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserPositionSelectReqVo", description = "用户新增编辑选择已有职位请求VO")
public class MdmUserPositionSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认条数")
    private Integer pageSize;

    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;

    @ApiModelProperty("精确查询这个组织下的职位")
    private String thisOrgCode;

    @ApiModelProperty("职位名称，模糊查询")
    private String positionName;

    @ApiModelProperty("包含这个用户的职位")
    private String includeUserName;

    @ApiModelProperty("组织名称/职位名称/用户名称")
    private String unionName;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodeList;

}