package com.biz.crm.common;

import com.biz.crm.nebular.mdm.enums.ParamCheckTypeEnum;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 导入参数前置校验
 * @author liaohua
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ParamCheck {
  /**
   * 是否必填（默认为必填）
   * @return
   */
  boolean isNotNull() default true;

  /**
   * 校验类型
   * 数字 : ParamCheckTypeEnum.NUMBER
   * 文本 : ParamCheckTypeEnum.TEXT
   * 字典 : ParamCheckTypeEnum.DICT
   * @return
   */
  ParamCheckTypeEnum[] checkType() default {};

  /**
   * 正则表达式
   * @return
   */
  String regexStr() default "";

  /**
   * 提示消息
   * @return
   */
  String msg() default "";

  /**
   * 字典类型
   */
  String dictType() default "";

  /**
   * 长度
   */
  int length() default 64;

  /**
   * 时间格式
   */
  String dateFormat() default "";

}
