package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Data
@ApiModel(value = "MdmCustomerContactPageReqVo", description = "客户信息主联系人分页入参")
@Accessors(chain = true)
public class MdmCustomerContactPageReqVo extends PageVo {

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("客户或联系人名称")
    private String customerOrContactName;

    @ApiModelProperty("客户编码或名称")
    private String customerCodeOrName;

    private List<String> customerCodeList;

    @ApiModelProperty("需要过滤的客户编码集合")
    private List<String> exclusiveCustomerCodeList;
}