package com.biz.crm.nebular.sfa.worksignrule;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 考勤规则-打卡人员 请求vo
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSignPersonnelReqVo", description = "考勤规则-打卡人员 ")
public class SfaWorkSignPersonnelVo extends CrmBaseVo {

    @ApiModelProperty("组织编码 组织编码")
    @SaturnColumn(description = "组织编码 组织编码")
    private String wspCode;

    @ApiModelProperty("组织名称 组织名称")
    @SaturnColumn(description = "组织名称 组织名称")
    private String wspName;

    @ApiModelProperty("是否当前组织(Y:当前组织;N:当前组织及下级组织)")
    @SaturnColumn(description = "是否当前组织(Y:当前组织;N:当前组织及下级组织)")
    private String currentAble;


    @ApiModelProperty("考勤规则编码 考勤规则编码")
    @SaturnColumn(description = "考勤规则编码 考勤规则编码")
    private String ruleCode;

    @ApiModelProperty("考勤规则编码集合 考勤规则编码集合")
    @SaturnColumn(description = "考勤规则编码集合 考勤规则编码集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<String> ruleCodes;

}