package com.biz.crm.nebular.tpm.income.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 收入预算;返回vo
 *
 * @author lf
 * @date 2021-02-02 17:55:15
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "收入预算;")
public class TpmIncomeBudgetRespVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("预算编码;预算编码")
    private String incomeCode;

    @ApiModelProperty("预算名称;预算名称")
    private String incomeName;

    @ApiModelProperty("年;年")
    private String budgetYear;

    @ApiModelProperty("年;年")
    private String budgetYearDesc;

    @ApiModelProperty("月份;月份")
    private String budgetMonth;

    @ApiModelProperty("月份;月份")
    private String budgetMonthDesc;

    @ApiModelProperty("组织编码;组织编码")
    private String orgCode;

    @ApiModelProperty("组织;组织")
    private String orgName;

    @ApiModelProperty("产品编码;产品编码")
    private String productCode;

    @ApiModelProperty("产品;产品")
    private String productName;

    @ApiModelProperty("分组编码;分组编码")
    private String incomeGroupCode;

    @ApiModelProperty("分组;分组")
    private String incomeGroupName;

    @ApiModelProperty("客户编码;客户编码")
    private String customerCode;

    @ApiModelProperty("客户;客户")
    private String customerName;

    @ApiModelProperty("门店编码;门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称;门店名称")
    private String terminalName;

    @ApiModelProperty("预算科目编码;预算科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("预算科目名称;预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("期初金额;期初金额")
    private BigDecimal initAmount;

    @ApiModelProperty("当前余额;当前余额")
    private BigDecimal amount;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("收入预算类型")
    private String incomeType;

    @ApiModelProperty("收入预算类型")
    private String incomeTypeName;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

}