package com.biz.crm.nebular.mdm.parametermanage.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 参数配置请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-24 10:47:10
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmParameterManageReqVo", description = "参数配置")
public class MdmParameterManageReqVo extends CrmBaseVo {

    @ApiModelProperty("参数")
    private String parameterCode;

    @ApiModelProperty("参数名称")
    private String parameterName;

    @ApiModelProperty("默认值")
    private String defaultValue;

    @ApiModelProperty("参数值")
    private String parameterValue;

    @ApiModelProperty("参数说明")
    private String parameterExplain;

    @ApiModelProperty("所属模块")
    private String parameterModule;

}