package com.biz.crm.nebular.mdm.bpmrole.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 流程角色下拉框请求参数vo
 *
 * @author Tao.Chen
 * @date 2020-11-26 20:07:10
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmBpmRoleSelectReqVo", description = "流程角色下拉框请求参数")
public class MdmBpmRoleSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认数量")
    private Integer pageSize;

    @ApiModelProperty("启用状态，精确查询")
    private String enableStatus;

    @ApiModelProperty("流程角色编码")
    private String bpmRoleCode;

    @ApiModelProperty("流程角色名称")
    private String bpmRoleName;

    @ApiModelProperty("角色编码或名称模糊查询")
    private String bpmRoleCodeOrName;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodeList;

}