package com.biz.crm.nebular.mdm.pricesetting.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDateTime;
import java.util.List;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 价格维护主表 请求vo
 *
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPriceSettingReqVo", description = "价格维护主表 ")
public class MdmPriceSettingReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("定价记录号")
    private String priceSettingCode;

    @ApiModelProperty("条件类型编码")
    private String conditionTypeCode;

    @ApiModelProperty("条件类型描述")
    private String conditionTypeDesc;

    @ApiModelProperty("条件字段分类编码")
    private String conditionGroupCode;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("渠道编码")
    private String channel;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("币种编码(字典currency_type)")
    private String currencyType;

    @ApiModelProperty("币种名称")
    private String currencyTypeName;

    @ApiModelProperty("单位类型 数据字典：unit_type")
    private String unitType;

    @ApiModelProperty("价格单位(字典,选项数据跟选择的商品有关)")
    private String priceUnit;

    @ApiModelProperty("价格单位名称")
    private String priceName;

    @ApiModelProperty("有效期开始日期")
    private String beginDate;

    @ApiModelProperty("有效期开始时间")
    private String beginDateSecond;

    @ApiModelProperty("有效期结束日期")
    private String endDate;

    @ApiModelProperty("有效期结束时间")
    private String endDateSecond;

    @ApiModelProperty("有效期开始日期时间")
    private LocalDateTime beginDateTime;

    @ApiModelProperty("有效期结束日期时间")
    private LocalDateTime endDateTime;


}