package com.biz.crm.nebular.mdm.user.req;

import com.bizunited.platform.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户关联微信请求vo
 *
 * @author Tao.Chen
 * @date 2021-02-19 16:39:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserRelWeChatReqVo", description = "用户关联微信")
public class MdmUserRelWeChatReqVo extends UuidVo {

    @ApiModelProperty("微信来源模块")
    private String originModule;

    @ApiModelProperty("用户登录名")
    private String userName;

    @ApiModelProperty("微信openId")
    private String openId;

    @ApiModelProperty("当前登录状态")
    private String loginStatus;

    @ApiModelProperty("微信头像")
    private String headImgUrl;

    @ApiModelProperty("微信昵称")
    private String nickName;

}