package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用池折扣上账请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDiscountAccountReqVo", description = "费用池折扣上账请求VO")
public class FeePoolDiscountAccountReqVo extends CrmExtTenVo {

    @ApiModelProperty("客户编码（必填）")
    private String customerCode;

    @ApiModelProperty("操作类型（必填），来自数据字典fee_pool_operation_type，或者枚举类FeePoolOperationTypeEnum")
    private String operationType;

    @ApiModelProperty("操作金额（必填）")
    private BigDecimal amount;

    @ApiModelProperty("折扣类型，来自数据字典fee_pool_discount_type")
    private String discountType;

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;
}