package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * 组织-客户关联分页列表
 *
 * @author zxw
 * @date 2020-10-09 18:13
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmOrgCustomerPageReqVo", description = "组织-客户关联分页列表")
public class MdmOrgCustomerPageReqVo extends PageVo {

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("组织编码")
    @NotBlank(message = "组织编码不能为空")
    private String orgCode;
}
