package com.biz.crm.nebular.activiti.act.req;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author weston
 * @date 2020-12-23
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "CopyToUserReqVO", description = "节点对象请求VO")
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class CopyToUserReqVO {
    @ApiModelProperty(value = "用户编码", required = true)
    private String userCode;

    @ApiModelProperty(value = "岗位编码", required = true)
    private String posCode;

    @ApiModelProperty(value = "用户名称", required = true)
    private String userName;

    @ApiModelProperty(value = "岗位名称", required = true)
    private String posName;

}
