package com.biz.crm.nebular.log.template;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/18 17:47
 **/
@ApiModel("日志规则字段对象")
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class LogFieldVo implements Serializable {

    @ApiModelProperty(value = "字段名称")
    private String fieldName;

    @ApiModelProperty(value = "字段描述")
    private String desc;

    @ApiModelProperty(value = "是否对比值(字典)")
    private Integer compareFalg;

    @ApiModelProperty(value = "字段类型（全路径）")
    private String type;

    @ApiModelProperty(value = "字段分类(字典crmlog_host_type)")
    private Integer hostType;

    @ApiModelProperty(value = "下级字段对象的list形式(非基本类型才有)")
    private List<LogFieldVo> childrenList;

    @ApiModelProperty(value = "当前字段新旧对象关键的唯一值(one2Many专用)")
    private String onlyKey;

    @ApiModelProperty(value = "当前字段新增对象或者删除对象的时候 唯一描述语句(指向模板字段的描述)（one2Many专属）")
    private String onlyKeyName;
}
