package com.biz.crm.nebular.mdm.product.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 请求vo
 *
 * @author crm
 * @date 2020-08-27 16:29:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class MdmProductMediaReqVo extends CrmBaseVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("地址")
    private String urlAddress;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("排序位置")
    private Integer rangeNum;

    @ApiModelProperty("文件类型('picture'图片,'video'视频)")
    private String type;

    @SaturnColumn(description = "文件名称")
    @ApiModelProperty("文件名称")
    private String fileName;

    @SaturnColumn(description = "源文件名称")
    @ApiModelProperty("源文件名称")
    private String originalFileName;

    @SaturnColumn(description = "目录")
    @ApiModelProperty("目录")
    private String relativeLocal;

}