package com.biz.crm.nebular.dms.promotion.policy.resp;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.util.CommonConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


/**
 * 计算规则计算结果
 *  @author: luoqi
 *  @Date: 2020-11-27 17:05
 *  @version: V1.0
 *  @Description:
 */
@Data
@ApiModel("计算规则计算结果")
public class CalculateRuleResponse {
    //计算结果类型 QTY_TYPE number:数量； amount:金额
    @ApiModelProperty(value = "计算结果类型 QTY_TYPE number:数量； amount:金额")
    private String resultDataType;
    //计算结果单位类型 ProductUnitEnum
    @ApiModelProperty(value = "计算结果单位类型 数据字典：unit_type 枚举类：ProductUnitEnum")
    private String resultDataUnitType;
    //计算结果
    @ApiModelProperty(value = "计算结果")
    private BigDecimal resultData;
    //使用的阶梯
    @ApiModelProperty(value = "使用的阶梯")
    private List<PromotionRuleEditVo.ControlRow> ladderUsed;
    //未匹配到阶梯时的描述说明
    @ApiModelProperty(value = "未匹配到阶梯时的描述说明")
    private String noLadderMatchMsg;
}
