package com.biz.crm.nebular.tpm.costtypefine.resp;

import com.biz.crm.common.DictItemVo;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 活动细类 返回vo
 *
 * @author huanglong
 * @date 2020-09-14 11:01:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动细类 ")
@CrmColumnResolve
@SaturnEntity(name = "TpmCostTypeFineRespVo", description = "活动细类 ")
public class TpmCostTypeFineRespVo extends CrmExtVo {
    @ApiModelProperty("活动细类编码")
    @SaturnColumn(description = "活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    @SaturnColumn(description = "活动细类名称")
    private String fineName;

    @ApiModelProperty("ERP会计科目编码")
    @SaturnColumn(description = "ERP会计科目编码")
    private String financeSubjectsErpCode;

    @ApiModelProperty("ERP会计科目名称")
    @SaturnColumn(description = "ERP会计科目名称")
    private String financeSubjectsErpName;

    @ApiModelProperty("活动发布需求(字典)")
    @SaturnColumn(description = "活动发布需求")
    private String activityReleaseNeed;

    @ApiModelProperty("活动发布需求名称")
    @SaturnColumn(description = "活动发布需求")
    private String activityReleaseNeedName;

    @ApiModelProperty("活动方式(字典)")
    @SaturnColumn(description = "活动方式")
    private String activityType;


    @ApiModelProperty("费用是否分摊到产品(Y/N)")
    private String isShareToProduct;

    @ApiModelProperty("活动方式名称")
    @SaturnColumn(description = "活动方式(字典)")
    private String activityTypeName;

    @ApiModelProperty("支付方式(集合的json,字典)")
    @SaturnColumn(description = "支付方式")
    private String payTypeList;

    @ApiModelProperty("支付方式(集合的json,字典)")
    @SaturnColumn(description = "支付方式")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<DictItemVo> payTypes;

    @ApiModelProperty("支付方式(字典)")
    @SaturnColumn(description = "支付方式")
    private String payTypeName;

    @ApiModelProperty("是否核销")
    @SaturnColumn(description = "是否核销")
    private String isAudit;

    @ApiModelProperty("是否自动核销")
    @SaturnColumn(description = "是否自动核销")
    private String isAutoAudit;

    @ApiModelProperty("允许多次核销")
    @SaturnColumn(description = "允许多次核销")
    private String isAllowRepeatAudit;

    @ApiModelProperty("超额核销比例")
    @SaturnColumn(description = "超额核销比例")
    private BigDecimal extraAuditRatio;

    @ApiModelProperty("核销有效期(月)")
    @SaturnColumn(description = "核销有效期(月)")
    private Integer auditValidity;

    @ApiModelProperty("是否推送SFA")
    @SaturnColumn(description = "是否推送SFA")
    private String isSendSfa;

    @ApiModelProperty("是否推送AI")
    @SaturnColumn(description = "是否推送AI")
    private String isSendAi;

    @ApiModelProperty("采集要求(集合的json)")
    @SaturnColumn(description = "采集要求(集合的json)")
    private String collectRequireList;

    @ApiModelProperty("采集要求(集合的json)")
    @SaturnColumn(description = "采集要求(集合的json)")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmAuditCollectExampleRespVo> collectRequires;

    @ApiModelProperty("核销资料要求(集合的json)")
    @SaturnColumn(description = "核销资料要求(集合的json)")
    private String auditRequireList;

    @ApiModelProperty("核销资料要求")
    @SaturnColumn(description = "核销资料要求")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmAuditCollectExampleRespVo> auditRequires;

    @ApiModelProperty("上账科目列表(集合的json,字典)")
    @SaturnColumn(description = "上账科目列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<DictItemVo> financeSubjectsErpList;

    @ApiModelProperty("采集字段集合")
    @SaturnColumn(description = "采集字段集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmActCollectFieldFineRespVo> collectFieldList;

    @ApiModelProperty("活动类型表单")
    private String costFormCode;

    @ApiModelProperty("适用层级(字典)")
    private String costLevel;

    @ApiModelProperty("适用组织编码")
    private String costOrgCode;

    @ApiModelProperty("适用组织名称")
    private String costOrgName;

    @ApiModelProperty("是否跨组织占用预算(Y/N)")
    private String isSpanOrgBudget;

    @ApiModelProperty("是否审核活动明细(Y/N)")
    private String isReviewActivityDetails;

    @ApiModelProperty("是否进行督导(Y/N)")
    private String isSupervise;

    @ApiModelProperty("是否需要采集资料(Y/N)")
    private String isNeedCollectData;

    @ApiModelProperty("是否需要核销资料(Y/N)")
    private String isNeedAuditData;

    @ApiModelProperty("当前tpm系统名称 tpm/liqueurTpm")
    private String tpmProjectName;

    @ApiModelProperty("活动细类与活动大类关联表")
    private List<TpmCostTypeCategoriesFineReqVo> tpmCostTypeCategoriesFineReqVo;


}