package com.biz.crm.nebular.mdm.button;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 按钮表返回vo
 *
 * @author zxw
 * @date 2020-11-18 11:33:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "按钮表")
@SaturnEntity(name = "MdmButtonRespVo", description = "按钮表")
@CrmColumnResolve
public class MdmButtonRespVo extends CrmExtTenVo {

    @ApiModelProperty("按钮编码")
    @SaturnColumn(description = "按钮编码")
    private String buttonCode;

    @ApiModelProperty("按扭名称")
    @SaturnColumn(description = "按钮名称")
    private String buttonName;

    @ApiModelProperty("图标编码")
    @SaturnColumn(description = "图标编码")
    private String iconCode;

    @ApiModelProperty("图标名称")
    @SaturnColumn(description = "图标名称")
    private String iconName;

    @ApiModelProperty("图标样式")
    @SaturnColumn(description = "图标样式")
    private String iconStyle;

    @ApiModelProperty("图标效果")
    @SaturnColumn(description = "图标效果")
    private String iconEffect;

    @ApiModelProperty("图标路径")
    private String iconUrl;

    @ApiModelProperty("按钮类型:0表头按钮，1行按钮")
    private String buttonType;

    @ApiModelProperty("按钮类型名称:0表头按钮，1行按钮(数据字典button_type)")
    @CrmDict(typeCode = DictConstant.BUTTON_TYPE,dictCodeField = "buttonType")
    private String buttonTypeName;

}